# btc4096_full_sim.py
# Simulation of fully expanded 4096-vector HDGL covenant
# Expansion done off-chain for visualization / testing
# On-chain only needs seed + recursive folding

MAX_VECTORS = 4096
BLOCK_SIZE = 4  # seed vectors per block
SAFE_ZERO = "0x0"

PARAMS = {
    1: ("0x3000", "0x812"),
    2: ("0x4000", "0x502"),
    3: ("0x5000", "0x310"),
    4: ("0x6000", "0x192"),
    5: ("0x7000", "0x119"),
    6: ("0x8000", "0x73"),
    7: ("0x9000", "0x45"),
    8: ("0xA000", "0x28"),
}

def simulate_full_hdgl(pubkey="<YOUR_PUBLIC_KEY>"):
    script = [f"{pubkey} OP_CHECKSIGVERIFY\n"]
    vector_count = 0

    # Step 1: Initial seed blocks
    for block_idx, (r_dim, omega) in PARAMS.items():
        script.append(f"{SAFE_ZERO} {SAFE_ZERO} {SAFE_ZERO} {SAFE_ZERO} OP_HDGL_VEC_ADD OP_EQUALVERIFY")
        idx_base = 100 + vector_count
        script.append(f"{idx_base} {idx_base+1} OP_ADD {idx_base+2} OP_EQUALVERIFY")
        script.append(f"{idx_base+3} {idx_base+4} {idx_base+5} OP_WITHINVERIFY")
        script.append(f"{r_dim} {omega} OP_HDGL_PARAM_ADD OP_EQUALVERIFY\n")
        vector_count += BLOCK_SIZE

    # Step 2: Logarithmic expansion
    # Keep folding until reaching MAX_VECTORS
    current_vectors = vector_count
    idx_offset = 100 + current_vectors
    while current_vectors < MAX_VECTORS:
        next_vectors = min(current_vectors*2, MAX_VECTORS)
        for v in range(current_vectors, next_vectors):
            # Duplicate + vector add
            script.append(f"{SAFE_ZERO} {SAFE_ZERO} {SAFE_ZERO} {SAFE_ZERO} OP_HDGL_VEC_ADD OP_EQUALVERIFY")
            idx_base = idx_offset
            script.append(f"{idx_base} {idx_base+1} OP_ADD {idx_base+2} OP_EQUALVERIFY")
            script.append(f"{idx_base+3} {idx_base+4} {idx_base+5} OP_WITHINVERIFY\n")
            idx_offset += BLOCK_SIZE
        current_vectors = next_vectors

    # Step 3: Final covenant
    script.append("OP_CHECKTEMPLATEVERIFY")
    return "\n".join(script)

if __name__ == "__main__":
    covenant_script = simulate_full_hdgl()
    print("=== Simulated Fully Expanded 4096-Vector HDGL Covenant ===")
    print(covenant_script)
